@echo off
title CLSTEAM SSD & FILE SYSTEM OPTIMIZER - Ultimate Storage Performance
setlocal enabledelayedexpansion

:: Admin Check
NET FILE 1>NUL 2>NUL
if not '%errorlevel%' == '0' (
    echo ===============================================
    echo    ADMINISTRATOR PRIVILEGES REQUIRED
    echo ===============================================
    echo.
    echo This script must be run as Administrator!
    echo.
    echo Please right-click on the script and select:
    echo "Run as administrator"
    echo.
    echo Press any key to exit...
    pause >nul
    exit /b 1
)

:Main
cls
echo ===============================================
echo    CLSTEAM SSD & FILE SYSTEM OPTIMIZER
echo    ULTIMATE STORAGE PERFORMANCE
echo ===============================================
echo.
echo Starting SSD and File System optimization...
echo.
timeout /t 2 /nobreak >nul

:: Detect Storage Devices
echo [1/45] Detecting Storage Devices...
echo.
wmic diskdrive get model,size,interfaceType,mediaType /format:table > %temp%\storage_info.txt 2>nul
fsutil fsinfo drives > %temp%\drives.txt 2>nul

set ssd_detected=0
set nvme_detected=0
set hdd_detected=0

echo Storage Devices Found:
for /f "skip=1 tokens=1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20 delims=," %%a in ('type "%temp%\storage_info.txt"') do (
    if not "%%a"=="" (
        echo   - %%a %%b %%c %%d %%e %%f %%g %%h %%i %%j %%k %%l %%m %%n %%o %%p %%q %%r %%s %%t
        echo %%a | find /i "SSD" >nul && set ssd_detected=1
        echo %%a | find /i "NVMe" >nul && set nvme_detected=1
        echo %%a | find /i "HDD" >nul && set hdd_detected=1
    )
)

echo.
if !ssd_detected! equ 1 echo SSD Detected: Yes
if !nvme_detected! equ 1 echo NVMe Detected: Yes
if !hdd_detected! equ 1 echo HDD Detected: Yes
echo.
timeout /t 3 /nobreak >nul

:: Disable Last Access Time Stamp
echo [2/45] Disabling Last Access Time Stamp...
fsutil behavior set disablelastaccess 1 >nul 2>&1 && echo   - Last access time stamping disabled
reg add "HKLM\SYSTEM\CurrentControlSet\Control\FileSystem" /v "NtfsDisableLastAccessUpdate" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - NTFS last access updates disabled
echo [SUCCESS] Last access time stamping disabled
echo.

:: Disable 8.3 File Name Creation
echo [3/45] Disabling 8.3 File Name Creation...
fsutil behavior set disable8dot3 1 >nul 2>&1 && echo   - 8.3 filename creation disabled
echo [SUCCESS] 8.3 file name creation disabled
echo.

:: Enable NTFS Long Paths
echo [4/45] Enabling NTFS Long Paths...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\FileSystem" /v "LongPathsEnabled" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Long paths enabled (260+ characters)
echo [SUCCESS] NTFS long paths enabled
echo.

:: Disable File System Compression
echo [5/45] Disabling File System Compression...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\FileSystem" /v "NtfsDisableCompression" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - File system compression disabled
echo [SUCCESS] File system compression disabled
echo.

:: Optimize NTFS Memory Usage
echo [6/45] Optimizing NTFS Memory Usage...
fsutil behavior set memoryusage 2 >nul 2>&1 && echo   - NTFS memory usage set to maximum
reg add "HKLM\SYSTEM\CurrentControlSet\Control\FileSystem" /v "NtfsMemoryUsage" /t REG_DWORD /d 2 /f >nul 2>&1 && echo   - NTFS memory usage registry set
echo [SUCCESS] NTFS memory usage optimized
echo.

:: Disable SuperFetch for SSDs
echo [7/45] Disabling SuperFetch for SSDs...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management\PrefetchParameters" /v "EnableSuperfetch" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - SuperFetch disabled
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management\PrefetchParameters" /v "EnablePrefetcher" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Prefetcher disabled
sc config "SysMain" start= disabled >nul 2>&1 && echo   - SysMain service disabled
sc stop "SysMain" >nul 2>&1 && echo   - SysMain service stopped
echo [SUCCESS] SuperFetch disabled for SSDs
echo.

:: Disable Windows Search Indexing
echo [8/45] Disabling Windows Search Indexing...
reg add "HKLM\SOFTWARE\Microsoft\Windows Search" /v "SetupCompletedSuccessfully" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Search indexing disabled
sc config "WSearch" start= disabled >nul 2>&1 && echo   - Windows Search service disabled
sc stop "WSearch" >nul 2>&1 && echo   - Windows Search service stopped
echo [SUCCESS] Windows Search indexing disabled
echo.

:: Enable TRIM Support
echo [9/45] Enabling TRIM Support...
fsutil behavior set disabledeletenotify 0 >nul 2>&1 && echo   - TRIM support enabled
reg add "HKLM\SYSTEM\CurrentControlSet\Control\FileSystem" /v "DisableDeleteNotification" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Delete notifications enabled for TRIM
echo [SUCCESS] TRIM support enabled
echo.

:: Disable Defragmentation for SSDs
echo [10/45] Disabling Defragmentation for SSDs...
schtasks /change /tn "Microsoft\Windows\Defrag\ScheduledDefrag" /disable >nul 2>&1 && echo   - Scheduled defragmentation disabled
reg add "HKLM\SOFTWARE\Microsoft\Dfrg\BootOptimizeFunction" /v "Enable" /t REG_SZ /d "N" /f >nul 2>&1 && echo   - Boot optimization defrag disabled
echo [SUCCESS] Defragmentation disabled for SSDs
echo.

:: Optimize Cluster Size
echo [11/45] Optimizing Cluster Size...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\FileSystem" /v "NtfsMftZoneReservation" /t REG_DWORD /d 4 /f >nul 2>&1 && echo   - MFT zone reservation set to maximum
echo [SUCCESS] Cluster size optimized
echo.

:: Disable File Creation Timestamp
echo [12/45] Disabling File Creation Timestamp...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\FileSystem" /v "NtfsDisableCreationTimeUpdate" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - File creation timestamp updates disabled
echo [SUCCESS] File creation timestamp disabled
echo.

:: Enable Large System Cache
echo [13/45] Enabling Large System Cache...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "LargeSystemCache" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Large system cache enabled
echo [SUCCESS] Large system cache enabled
echo.

:: Disable Paging Executive
echo [14/45] Disabling Paging Executive...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "DisablePagingExecutive" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Paging executive disabled
echo [SUCCESS] Paging executive disabled
echo.

:: Optimize I/O Page Lock Limit
echo [15/45] Optimizing I/O Page Lock Limit...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "IOPageLockLimit" /t REG_DWORD /d 4194304 /f >nul 2>&1 && echo   - I/O page lock limit set to 4GB
echo [SUCCESS] I/O page lock limit optimized
echo.

:: Disable Windows Write Cache Buffer Flushing
echo [16/45] Optimizing Write Cache...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\FileSystem" /v "NtfsDisableWindowsWriteCacheBufferFlushing" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Write cache buffer flushing disabled
echo [SUCCESS] Write cache optimized
echo.

:: Enable Advanced Performance Mode
echo [17/45] Enabling Advanced Performance Mode...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\FileSystem" /v "NtfsEnableAdvancedPerformance" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Advanced performance mode enabled
echo [SUCCESS] Advanced performance mode enabled
echo.

:: Disable Short File Name Generation
echo [18/45] Disabling Short File Name Generation...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\FileSystem" /v "NtfsDisable8dot3NameCreation" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - 8.3 name generation disabled
echo [SUCCESS] Short file name generation disabled
echo.

:: Optimize MFT Allocation
echo [19/45] Optimizing MFT Allocation...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\FileSystem" /v "NtfsMftZoneReservation" /t REG_DWORD /d 4 /f >nul 2>&1 && echo   - MFT reservation zone increased
echo [SUCCESS] MFT allocation optimized
echo.

:: Disable Boot Logging
echo [20/45] Disabling Boot Logging...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager" /v "BootExecute" /t REG_MULTI_SZ /d "autocheck autochk *" /f >nul 2>&1 && echo   - Boot logging disabled
echo [SUCCESS] Boot logging disabled
echo.

:: Enable AHCI Link Power Management
echo [21/45] Enabling AHCI Link Power Management...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Power\PowerSettings\0012ee47-9041-4b5d-9b77-535fba8b1442\0b2d69d7-a2a1-449c-9680-f91c70521c60" /v "Attributes" /t REG_DWORD /d 2 /f >nul 2>&1 && echo   - AHCI LPM settings unlocked
powercfg -setacvalueindex SCHEME_CURRENT SUB_SLEEP HIBERNATEIDLE 0 >nul 2>&1 && echo   - Hibernate idle disabled
echo [SUCCESS] AHCI link power management enabled
echo.

:: Disable System Restore for SSDs
echo [22/45] Disabling System Restore for SSDs...
vssadmin delete shadows /all /quiet >nul 2>&1 && echo   - All restore points deleted
reg add "HKLM\SOFTWARE\Policies\Microsoft\Windows NT\SystemRestore" /v "DisableSR" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - System Restore disabled
echo [SUCCESS] System Restore disabled for SSDs
echo.

:: Optimize Page File for SSDs
echo [23/45] Optimizing Page File for SSDs...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "PagingFiles" /t REG_MULTI_SZ /d "C:\pagefile.sys 2048 4096" /f >nul 2>&1 && echo   - Page file optimized for SSDs
echo [SUCCESS] Page file optimized for SSDs
echo.

:: Disable Hibernation for SSDs
echo [24/45] Disabling Hibernation for SSDs...
powercfg -h off >nul 2>&1 && echo   - Hibernation disabled
echo [SUCCESS] Hibernation disabled for SSDs
echo.

:: Enable Write Caching
echo [25/45] Enabling Write Caching...
reg add "HKLM\SYSTEM\CurrentControlSet\Services\disk" /v "EnableWriteCache" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Write caching enabled
echo [SUCCESS] Write caching enabled
echo.

:: Disable Indexing Service
echo [26/45] Disabling Indexing Service...
sc config "CscService" start= disabled >nul 2>&1 && echo   - Offline Files service disabled
sc stop "CscService" >nul 2>&1 && echo   - Offline Files service stopped
echo [SUCCESS] Indexing service disabled
echo.

:: Optimize File System Cache
echo [27/45] Optimizing File System Cache...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "SystemPages" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - System pages optimized
echo [SUCCESS] File system cache optimized
echo.

:: Disable Timestamp Updates
echo [28/45] Disabling Timestamp Updates...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\FileSystem" /v "NtfsDisableLastAccessUpdate" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Timestamp updates disabled
echo [SUCCESS] Timestamp updates disabled
echo.

:: Enable NTFS Symbolic Links
echo [29/45] Enabling NTFS Symbolic Links...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\FileSystem" /v "SymlinkEnable" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Symbolic links enabled
echo [SUCCESS] NTFS symbolic links enabled
echo.

:: Optimize Disk Timeout Values
echo [30/45] Optimizing Disk Timeout Values...
reg add "HKLM\SYSTEM\CurrentControlSet\Services\Disk" /v "TimeOutValue" /t REG_DWORD /d 60 /f >nul 2>&1 && echo   - Disk timeout increased to 60 seconds
echo [SUCCESS] Disk timeout values optimized
echo.

:: Disable File System Journaling
echo [31/45] Disabling File System Journaling...
fsutil usn deletejournal /d C: >nul 2>&1 && echo   - USN journal deleted
reg add "HKLM\SYSTEM\CurrentControlSet\Control\FileSystem" /v "NtfsDisableUsnJournaling" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - USN journaling disabled
echo [SUCCESS] File system journaling disabled
echo.

:: Enable NTFS Compression Exemption
echo [32/45] Enabling NTFS Compression Exemption...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\FileSystem" /v "NtfsAllowExtendedCharacterIn8dot3Name" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Extended characters in 8.3 names allowed
echo [SUCCESS] NTFS compression exemption enabled
echo.

:: Optimize Disk Queue Depth
echo [33/45] Optimizing Disk Queue Depth...
reg add "HKLM\SYSTEM\CurrentControlSet\Services\stornvme\Parameters" /v "MaxQueueDepth" /t REG_DWORD /d 32 /f >nul 2>&1 && echo   - NVMe queue depth optimized
reg add "HKLM\SYSTEM\CurrentControlSet\Services\storahci\Parameters" /v "MaxQueueDepth" /t REG_DWORD /d 32 /f >nul 2>&1 && echo   - AHCI queue depth optimized
echo [SUCCESS] Disk queue depth optimized
echo.

:: Disable File System Notifications
echo [34/45] Disabling File System Notifications...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\FileSystem" /v "NtfsDisableFileSystemNotify" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - File system notifications disabled
echo [SUCCESS] File system notifications disabled
echo.

:: Enable Fast Boot for SSDs
echo [35/45] Enabling Fast Boot for SSDs...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Power" /v "HiberbootEnabled" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Fast boot enabled
echo [SUCCESS] Fast boot enabled for SSDs
echo.

:: Optimize SSD Garbage Collection
echo [36/45] Optimizing SSD Garbage Collection...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\FileSystem" /v "NtfsDisableSsdGarbageCollection" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - SSD garbage collection optimized
echo [SUCCESS] SSD garbage collection optimized
echo.

:: Disable Volume Shadow Copy
echo [37/45] Disabling Volume Shadow Copy...
vssadmin delete shadows /all /quiet >nul 2>&1 && echo   - Shadow copies deleted
sc config "VSS" start= disabled >nul 2>&1 && echo   - Volume Shadow Copy service disabled
sc stop "VSS" >nul 2>&1 && echo   - VSS service stopped
echo [SUCCESS] Volume shadow copy disabled
echo.

:: Enable NTFS Hotfix Optimizations
echo [38/45] Enabling NTFS Hotfix Optimizations...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\FileSystem" /v "NtfsEnableHotfix" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - NTFS hotfix optimizations enabled
echo [SUCCESS] NTFS hotfix optimizations enabled
echo.

:: Optimize File System Buffer Size
echo [39/45] Optimizing File System Buffer Size...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "PagedPoolSize" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Paged pool size optimized
echo [SUCCESS] File system buffer size optimized
echo.

:: Disable Windows Event Logging for Disk
echo [40/45] Disabling Disk Event Logging...
reg add "HKLM\SYSTEM\CurrentControlSet\Services\Eventlog\System" /v "MaxSize" /t REG_DWORD /d 32768 /f >nul 2>&1 && echo   - Event log size limited
echo [SUCCESS] Disk event logging optimized
echo.

:: Create SSD Maintenance Tool
echo [41/45] Creating SSD Maintenance Tool...
echo @echo off > "%TEMP%\SSD_Maintenance.bat"
echo echo CLSTEAM SSD Maintenance Tool >> "%TEMP%\SSD_Maintenance.bat"
echo echo ============================ >> "%TEMP%\SSD_Maintenance.bat"
echo echo. >> "%TEMP%\SSD_Maintenance.bat"
echo echo Running SSD Optimizations... >> "%TEMP%\SSD_Maintenance.bat"
echo fsutil behavior set disabledeletenotify 0 ^>nul 2^>^&1 >> "%TEMP%\SSD_Maintenance.bat"
echo defrag C: /O /U ^>nul 2^>^&1 >> "%TEMP%\SSD_Maintenance.bat"
echo echo. >> "%TEMP%\SSD_Maintenance.bat"
echo echo SSD maintenance completed! >> "%TEMP%\SSD_Maintenance.bat"
echo echo Press any key to exit... >> "%TEMP%\SSD_Maintenance.bat"
echo pause ^>nul >> "%TEMP%\SSD_Maintenance.bat"
echo [SUCCESS] SSD maintenance tool created
echo.

:: Run TRIM Command
echo [42/45] Running TRIM Optimization...
defrag C: /O /U >nul 2>&1 && echo   - TRIM optimization executed
echo [SUCCESS] TRIM optimization completed
echo.

:: Update File System Settings
echo [43/45] Updating File System Settings...
chkdsk C: /scan /forceofflinefix >nul 2>&1 && echo   - File system checked
echo [SUCCESS] File system settings updated
echo.

:: Cleanup Temporary Files
echo [44/45] Cleaning Temporary Files...
del /q /f %temp%\storage_info.txt >nul 2>&1
del /q /f %temp%\drives.txt >nul 2>&1
echo [SUCCESS] Temporary files cleaned
echo.


:: Completion Message
echo ===============================================
echo    SSD & FILE SYSTEM OPTIMIZATION COMPLETE!
echo ===============================================
echo.
echo All SSD and file system optimizations have been applied!
echo.
echo Summary of optimizations performed:
echo ✓ Last access time stamping disabled
echo ✓ 8.3 file name creation disabled
echo ✓ NTFS long paths enabled
echo ✓ File system compression disabled
echo ✓ NTFS memory usage optimized
echo ✓ SuperFetch and Prefetcher disabled
echo ✓ Windows Search indexing disabled
echo ✓ TRIM support enabled
echo ✓ Defragmentation disabled for SSDs
echo ✓ MFT and cluster size optimized
echo ✓ Large system cache enabled
echo ✓ Write cache optimized
echo ✓ Advanced performance mode enabled
echo ✓ AHCI link power management enabled
echo ✓ System Restore disabled for SSDs
echo ✓ Page file optimized for SSDs
echo ✓ Hibernation disabled for SSDs
echo ✓ Disk queue depth optimized
echo ✓ Fast boot enabled
echo ✓ SSD garbage collection optimized
echo ✓ Volume shadow copy disabled
echo.
echo Performance Benefits:
echo - Faster file operations
echo - Reduced SSD wear
echo - Improved system responsiveness
echo - Better gaming performance
echo - Faster application loading
echo - Extended SSD lifespan
echo.
echo Additional Tools Created:
echo - %TEMP%\SSD_Maintenance.bat : Run monthly for SSD maintenance
echo.
echo IMPORTANT: Restart your computer for all changes to take effect!
echo.
echo CLSTEAM SSD & FILE SYSTEM OPTIMIZER
echo Optimization completed at: %date% %time%
echo ===============================================
echo.
echo Press Enter to exit...
pause >nul
exit